---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-401ページ (Unauthorized)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/client/components/builtin/unauthorized.tsx` L1-10 - コンポーネント全体
- E-02: `packages/next/src/client/components/http-access-fallback/error-fallback.tsx` L1-45 - HTTPAccessErrorFallback
- E-03: `packages/next/src/client/components/styles/access-error-styles.ts` L1-34 - スタイル定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` L10 - 画面情報定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` L24-25 - 関連機能情報
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md` L49 - unauthorized()遷移

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 未認証ユーザーに表示される | E-04, E-06 | ○ |
| C-02 | unauthorized()関数呼び出し時に表示 | E-04, E-06 | ○ |
| C-03 | HTTPAccessErrorFallbackにstatus=401を渡す | E-01 | ○ |
| C-04 | message="You're not authorized to access this page."を表示 | E-01 | ○ |
| C-05 | h1に401、h2にメッセージを表示 | E-02 | ○ |
| C-06 | titleタグにステータスとメッセージを設定 | E-02 | ○ |
| C-07 | ダークモード対応 | E-02 | ○ |
| C-08 | App Routerで使用 | E-04 | ○ |
| C-09 | プロパティを受け取らない | E-01 | ○ |
| C-10 | html/bodyタグを含まない | E-01 | ○ |
| C-11 | エラーハンドリングが主機能、App Routerが補助機能 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] unauthorized()関数の呼び出し元に関する記述が正確か確認
- [ ] メッセージ文言が実装と一致するか確認
